/*
 * Decompiled with CFR 0.152.
 */
package com.tom.chunkstorage.impl;

import com.tom.chunkstorage.ChunkStorage;
import com.tom.chunkstorage.api.ChunkStorageApi;
import com.tom.chunkstorage.api.DataObject;
import com.tom.chunkstorage.api.DataObjectKey;
import com.tom.chunkstorage.impl.FallbackObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class DataStorage {
    private Map<DataObjectKey<?>, DataObject> data;

    public class_2487 save() {
        if (this.data == null || this.data.isEmpty()) {
            return null;
        }
        class_2487 tag = new class_2487();
        this.data.forEach((r, e) -> {
            try {
                tag.method_10566(r.id(), (class_2520)e.save());
            }
            catch (Exception ex) {
                ChunkStorage.LOGGER.error("Data object failed to save, please report it to the mod author. Object ID: " + r, (Throwable)ex);
            }
        });
        return tag;
    }

    public void load(class_2487 compound) {
        if (!compound.method_33133()) {
            this.data = new HashMap();
            compound.method_10541().forEach(key -> {
                try {
                    class_2960 rl = new class_2960(key);
                    class_2487 tag = compound.method_10562(key);
                    DataObjectKey<?> k = ChunkStorageApi.getKey(rl);
                    if (k == null) {
                        k = FallbackObject.key(rl);
                    }
                    Object obj = k.createNew();
                    obj.load(tag);
                    this.data.put(k, (DataObject)obj);
                }
                catch (Exception ex) {
                    ChunkStorage.LOGGER.error("Data object failed to load, please report it to the mod author. Object ID: " + key, (Throwable)ex);
                }
            });
        }
    }

    public <T extends DataObject> T get(DataObjectKey<T> key) {
        if (this.data == null) {
            return null;
        }
        DataObject d = this.data.get(key);
        if (d instanceof FallbackObject) {
            return null;
        }
        return (T)d;
    }

    public <T extends DataObject> T getOrCreate(DataObjectKey<T> key) {
        DataObject d;
        if (this.data == null) {
            this.data = new HashMap();
        }
        if ((d = this.data.computeIfAbsent(key, DataObjectKey::createNew)) instanceof FallbackObject) {
            throw new IllegalStateException("Attempting to access an unregistered type, please report it to the mod author! Object ID: " + key.id());
        }
        return (T)d;
    }
}

